function [FinalImage] = ReadTiffStack(FileTif)
warning off;
% Optional argument to read frames in the range [lo high]

InfoImage=imfinfo(FileTif);
mImage=InfoImage(1).Width;
nImage=InfoImage(1).Height;
NumberImages=length(InfoImage);


frange = [1 NumberImages];

FinalImage=zeros(nImage,mImage,frange(2)-frange(1)+1,'uint16');
if(~exist('tifflib','file'))
    
    TifLink = Tiff(FileTif, 'r');
    cntr = 1;
    for i=frange(1):frange(end)
        TifLink.setDirectory(i);
        FinalImage(:,:,cntr)=TifLink.read();
 
        cntr = cntr+1;
    end
    TifLink.close();
else
    FileID = tifflib('open',FileTif,'r');
    rps = tifflib('getField',FileID,Tiff.TagID.RowsPerStrip);
    
    cntr = 1;
    for i=frange(1):frange(2)
        tifflib('setDirectory',FileID,i);
        % Go through each strip of data.
        rps = min(rps,nImage);
        for r = 1:rps:nImage
            row_inds = r:min(nImage,r+rps-1);
            stripNum = tifflib('computeStrip',FileID,r-1);
            FinalImage(row_inds,:,cntr) = tifflib('readEncodedStrip',FileID,stripNum-1);
        end
        cntr = cntr+1;
    end
    tifflib('close',FileID);
end